<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.0 Alpha 5
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2009 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
 * CMS Article Data Manager
 *
 * @package vBulletin
 * @author vBulletin Development Team
 * @version $Revision: 28694 $
 * @since $Date: 2008-12-04 16:12:22 +0000 (Thu, 04 Dec 2008) $
 * @copyright Jelsoft Enterprises Ltd.
 */
class vBCms_DM_Article extends vBCms_DM_Node
{
	/*Properties====================================================================*/

	/**
	* Field definitions.
	* The field definitions are in the form:
	*	array(fieldname => array(VF_TYPE, VF_REQ, VF_METHOD, VF_VERIFY)).
	*
	* @var array string => array(int, int, mixed)
	*/
	protected $type_fields = array(
		'pagetext' => 			array(vB_Input::TYPE_STR,		self::REQ_YES),
		'threadid' =>			array(vB_Input::TYPE_INT,		self::REQ_NO),
		'blogid' =>			array(vB_Input::TYPE_INT,		self::REQ_NO),
		'blogpostid' =>			array(vB_Input::TYPE_INT,		self::REQ_NO),
		'postid' =>			array(vB_Input::TYPE_INT,		self::REQ_NO),
		'poststarter' =>			array(vB_Input::TYPE_INT,		self::REQ_NO),
		'post_started' =>			array(vB_Input::TYPE_INT,		self::REQ_NO),
		'post_posted' =>			array(vB_Input::TYPE_INT,		self::REQ_NO),
		'posttitle' =>		array(vB_Input::TYPE_STR,		self::REQ_NO,	self::VM_CALLBACK,	array('vB_Validate', 'stringLength', 1, 256)),
		'postauthor' =>		array(vB_Input::TYPE_STR,		self::REQ_NO,	self::VM_CALLBACK,	array('vB_Validate', 'stringLength', 1, 100)),
		'previewtext' =>			array(vB_Input::TYPE_STR,		self::REQ_NO),
		'previewimage' =>			array(vB_Input::TYPE_STR,		self::REQ_NO),
		'imagewidth' =>			array(vB_Input::TYPE_INT,		self::REQ_NO),
		'imageheight' =>			array(vB_Input::TYPE_INT,		self::REQ_NO)
	);

	/**
	 * Map of table => field for fields that can automatically be updated with their
	 * set value.
	 *
	 * @var array (tablename => array(fieldnames))
	 */
	protected $type_table_fields = array(
			'cms_article' =>		array('pagetext', 'threadid' , 'blogid', 'posttitle' ,
				'postauthor', 'poststarter' , 'postid', 'blogpostid',
				'post_started', 'post_posted', 'previewtext', 'previewimage', 'imagewidth',
				'imageheight')
	);

	/**
	 * Table name of the primary table.
	 *
	 * @var string
	 */
	protected $type_table = 'cms_article';

	/**
	 * vB_Item Class.
	 *
	 * @var string
	 */
	protected $item_class = 'vBCms_Item_Content_Article';

	/**
	 * Whether to reindex the content after an update.
	 *
	 * @var bool
	 */
	protected $index_search = true;


	/*Save==========================================================================*/

	/**
	 * Resolves the condition SQL to be used in update queries.
	 *
	 * @param string $table						- The table to get the condition for
	 * @return string							- The resolved sql
	 */
	protected function getTypeConditionSQL($table)
	{
		$this->assertItem();

		return 'contentid = ' . intval($this->item->getId());
	}


	/**
	 * Fetches the value to update the node description when content is updated.
	 *
	 * @return string
	 */
	protected function getUpdatedNodeDescription()
	{
		return $this->set_fields['title'];
	}
}

/*======================================================================*\
|| ####################################################################

|| # CVS: $RCSfile$ - $Revision: 28749 $
|| ####################################################################
\*======================================================================*/